/*
 * Book Swap -- swap books.
 * 0.1.1.B - Add prefix for Card, add Quit & Quit with Reset, add "Resetting..." prompt.
 */

var CopyAction = function () { };
CopyAction.prototype = {
    initialize: function () {
        target.setVariable("MENU_INDEX_COUNT", "1 of 1");
        target.resetMenu();

        var source = this.previous.previous.book.path;
        var dest = source;
        var index = dest.lastIndexOf('/');
        if (0 < index) {
            dest = dest.substring(index + 1, dest.length);
        }
        dest = this.previous.volume.path + dest;
        target.LABEL0.setValue("Copying file...");
        target.LABEL1.setValue("From: " + source);
        target.LABEL2.setValue("To: " + dest);
        if (this.copyFile(source, dest)) {
            target.LABEL9.setValue("Succeeded! :-)");
            target.actionCompleted();
        } else {
            target.LABEL9.setValue("Failed! :-(");
        }
    },
    copyFile: function (from, to) {
        try {
            FileSystem.copyFile(from, to);
        } catch(e) {
            return false;
        }
        return !!FileSystem.getFileInfo(to);
    }
};

var MoveAction = function () { };
MoveAction.prototype = {
    initialize: function () {
        target.setVariable("MENU_INDEX_COUNT", "1 of 1");
        target.resetMenu();

        var source = this.previous.previous.book.path;
        var dest = source;
        var index = dest.lastIndexOf('/');
        if (0 < index) {
            dest = dest.substring(index + 1, dest.length);
        }
        dest = this.previous.volume.path + dest;
        target.LABEL0.setValue("Moving file...");
        target.LABEL1.setValue("From: " + source);
        target.LABEL2.setValue("To: " + dest);
        if (this.moveFile(source, dest)) {
            target.LABEL9.setValue("Succeeded! :-)");
            target.actionCompleted();
        } else {
            target.LABEL9.setValue("Failed! :-(");
        }
    },
    moveFile: function (from, to) {
        try {
            FileSystem.copyFile(from, to);
        } catch(e) {
            return false;
        }
        if (!FileSystem.getFileInfo(to)) {
            return false;
        }
        try {
            FileSystem.deleteFile(from);
        } catch(e) {
            return false;
        }
        return !FileSystem.getFileInfo(from);        
    }
};

var DeleteAction = function () { };
DeleteAction.prototype = {
    initialize: function () {
        target.setVariable("MENU_INDEX_COUNT", "1 of 1");
        target.resetMenu();

        var source = this.previous.book.path;

        target.LABEL0.setValue("Deleting file...");
        target.LABEL1.setValue("From: " + source);
        if (this.deleteFile(source)) {
            target.LABEL9.setValue("Succeeded! :-)");
            target.actionCompleted();
        } else {
            target.LABEL9.setValue("Failed! :-(");
        }
    },
    deleteFile: function (from) {
        try {
            FileSystem.deleteFile(from);
        } catch(e) {
            return false;
        }
        return !FileSystem.getFileInfo(from);
    }
};

var ChooseFile = function (next) {
    this.next = next;
    this.page = 1;
};
ChooseFile.prototype = {
    initialize: function () {
        var books = this.previous.volume.books;
        books.sort(SortBooks);
        var maximum = books.length - ((this.page - 1) * 10);
        if (maximum > 10) maximum = 10;

        // How do I convert to an integer in this strange world?
        this.pages = books.length / 10;
        var ipages = 0;
        while (ipages < this.pages) ipages += 1;
        this.pages = ipages;

        target.setVariable("MENU_INDEX_COUNT", 
                           this.page + " of " + this.pages);
        target.resetMenu();

        for (var i = 0; i < maximum; i++) {
            var book = books[((this.page - 1) * 10) + i];
            target['LABEL' + i].setValue(book.author + ' - ' + book.title);
        }
    },
    doPrevious: function () {
        if (1 < this.page) {
            this.page -= 1;
            this.initialize();
        }
    },
    doNext: function () {
        if (this.page < this.pages) {
            this.page += 1;
            this.initialize();
        }
    },
    doFirst: function () {
        this.page -= 10;
        if (this.page < 1) {
            this.page = 1;
        }
        this.initialize();
    },
    doLast: function () {
        this.page += 10;
        if (this.page > this.pages) {
            this.page = this.pages;
        }
        this.initialize();
    },
    doDigit: function (key) {
        var books = this.previous.volume.books;
        this.book = books[((this.page - 1) * 10) + key];
        target.descend(this.next);
    }
    
};

function SortBooks(a, b) {
    var a1 = a.author;
    var b1 = b.author;
    var a2 = a.title;
    var b2 = b.title;
    return (a1 < b1) ? -1 : ((a1 > b1) ? 1 : (a2 < b2) ? -1 : ((a2 > b2) ? 1 : 0));
}

var ChooseVolume = function (prompt, next) {
    this.prompt = prompt;
    this.next = next;
};
ChooseVolume.prototype = {
   initialize: function () {
        target.setVariable("MENU_INDEX_COUNT", "1 of 1");
        target.resetMenu();
        var volumes = target.volumes;
        for (var i = 0; i < volumes.length; i++) {
            var volume = volumes[i];
            target['LABEL' + i].setValue(this.prompt + " " + volume.title);
        }
    },
    doDigit: function (key) {
        this.volume = target.volumes[key];
        target.descend(this.next);
    },
};

var CopyBook = {
    label: "Copy book",
    action: 
        new ChooseVolume("From", 
            new ChooseFile(
                new ChooseVolume("To",
                    new CopyAction()))),
};

var MoveBook = { 
    label: "Move book",
    action: 
        new ChooseVolume("From", 
            new ChooseFile(
                new ChooseVolume("To",
                    new MoveAction()))),
};

var DeleteBook = {
    label: "Delete book",
    action:
        new ChooseVolume("From", 
            new ChooseFile(
                new DeleteAction())),
};

var ListBooks = {
    label: "List books",
    action: 
        new ChooseVolume("From", 
            new ChooseFile()),
};

var ChooseOperation = {
    initialize: function () {
        target.resetMenu();
        target.setVariable("MENU_INDEX_COUNT", "1 of 1");
        for (var i = 0; i < this.operations.length; i++) {
            operation = this.operations[i];
            target['LABEL' + i].setValue(operation.label);
        }
        if (target.madeChanges) {
            target.LABEL8.setValue("Quit with Restart");
        }
        target.LABEL9.setValue("Quit");
    },
    doDigit: function (key) {
        if (key < this.operations.length) {
            operation = this.operations[key].action;
            target.descend(operation);
        } else if (key == 8) {
            if (target.madeChanges) {
                target.resetMenu();
                target.LABEL9.setValue("Restarting...");
                kbook.model.initialized();
            }
            kbook.autoRunRoot.exitIf(kbook.model);
        } else if (key == 9) {
            kbook.autoRunRoot.exitIf(kbook.model);
        }
    },
    operations: [ CopyBook, MoveBook, DeleteBook, ListBooks ],
};
ChooseOperation.previous = ChooseOperation;

target.madeChanges = false;
target.current = ChooseOperation;
target.actionCompleted = function () {
    this.madeChanges = true;
    this.current = ChooseOperation;
}

target.descend = function (operation) {
    operation.previous = this.current;
    this.current = operation;
    operation.initialize();
};

target.volumes = [];
target.findFiles = function () {
    var records = kbook.hardResetRoot.cache.records;
    var volume = {
        'title': "Internal Memory",
        'path': "/Data/",
        'books': []
    };
    this.volumes.push(volume);
    
    for (var i = 0; i < records.length; i++) {
        var record = records[i];
        if (!record) continue;
        
        if (record.hasOwnProperty('volume')) {
            volume = {
                'title': record.title,
                'path': record.path,
                'books': []
            };
            this.volumes.push(volume);
        } else if (record.hasOwnProperty('author')) {
            book = {
                'title': record.title,
                'author': record.author,
                'path': volume.path + record.path
            };
            volume.books.push(book);
        }
    }
};


target.resetMenu = function () {
    for (var i = 0; i < 10; i++) {
        this['LABEL' + i].setValue("");
    }
};
    
target.initialize = function () {
    try {
        this.findFiles();
        this.current.initialize();
    } catch (e) {
        this.LABEL7.setValue("2 Exception: " + e);
    }
};

target.doDigit = function (part) {
    key = (part.key - 1);
    if (key == -1) key = 9;
    try {
        if (this.current.doDigit) {
            this.current.doDigit(key);
        }
    } catch (e) {
        this.LABEL7.setValue("3 Exception: " + e);
    }
};

target.doNext = function () {
    if (this.current.doNext) {
        this.current.doNext();
    }
};

target.doPrevious = function () {
    if (this.current.doPrevious) {
        this.current.doPrevious();
    }
};

target.doFirst = function () {
    if (this.current.doFirst) {
        this.current.doFirst();
    }
};

target.doLast = function () {
    if (this.current.doLast) {
        this.current.doLast();
    }
};

target.doMenu = function () {
    this.current = this.current.previous;
    this.current.initialize();
};

